**************************************************************************************************************************************************
******************* Code for 'Are Investment Tax Breaks Effective: Australian Evidence' *******************
***************************************************** Code for DD regressions using Buildings - Appendix C ******************************************************************

**************************************************DATE: Jun 2024 ******************************************************************************
*********************************************************************************************************************************************
*** Code strcuture
*00. Preliminaries and globals
*01. Load data
*02 MAke variable
*03 Regressions and charting for each policy

************* 00. Preliminaries **********					  


clear all
global data ""
global savefile ""
sysdir set PLUS ""
sysdir set PERSONAL ""
mata: mata mlib index

************* 01. Laod and clean data **********					  

use "$data\capex_bit_frame_eginc_COY_20.dta", clear

recode quarter (1=3 "Sep") (2=4 "Dec") (3=1 "Mar") (4=2 "June"), gen(CalQuarter)
gen time = yq(year, quarter)-2
format time %tq
drop if time==.


gen company = (bit_comp_ ==1 )	
gen individual = (bit_ind_ ==1 )	
gen partnership= (bit_part_ ==1 )	
gen trust= (bit_trust_ ==1 )

gen NotCompany = (bit_comp_ !=1 )	
gen NotCompanyNorTrust = (bit_comp_ !=1 & bit_trust_ !=1)	

encode division, g(div)
************* 02. MAke key varaibles **********					  

*log LHS variables
g l_caeqtot=ln(caeqtot)
g l_ce1eqtot=ln(ce1eqtot_capex) // ce1 variables are short term expectations - not used
g l_ce2eqtot=ln(ce2eqtot_capex) // ce2 variables are long term expectations - not used

g l_cabltot = ln(cabltot)
g l_ce1bltot = ln(ce1bltot)
g l_ce2bltot = ln(ce2bltot)

*LHS non-zero firms
g caeqtot_nz = caeqtot
g ce1eqtot_capex_nz = ce1eqtot
g ce2eqtot_capex_nz = ce2eqtot_capex

replace caeqtot_nz=. if caeqtot_capex==0
replace ce1eqtot_capex_nz = . if ce1eqtot_capex==0
replace ce2eqtot_capex_nz = . if ce2eqtot_capex==0

g inv = 1 if (cabltot_capex>0 & cabltot_capex!=.)
g exp_1 = 1 if (ce1bltot_capex>0 & ce1bltot_capex!=.)
g exp_2 = 1 if (ce2bltot_capex>0 & ce2bltot_capex!=.)

*egen firmid = group(id_bg)
duplicates drop firmid date, force
xtset firmid date

*RHS variables
gen l_income_l = ln(income_l)
gen l_income_l2 = ln(income_l2)
gen l_income= log(income)
xtile pct_income = l_income, nquantiles(10)
gen l_fte = ln(fte)

************* 03. REgressions **********					  

**************************************************************************************************************************************************
*2008 GFC policy
**************************************************************************************************************************************************
*1. Create policy treatment groups
*********************************
*pre trend: 42 to 47
*policy: 48 to 51
*next policy starts at 62 (pretrend ends at 61)
gen policy_group_2008 = .
replace  policy_group_2008 = 1 if (income_l < 2 000 000)
replace  policy_group_2008 = 0 if (income_l > 2 000 000 & income_l < 5 000 000)


g pol_period_2008 =  0
replace pol_period = 1 if (quarter == 1 & year == 2010) | (quarter == 2 & year == 2010)
// (quarter == 3 & year == 2009) | (quarter == 4 & year == 2009) |  (quarter == 1 & year == 2010) | (quarter == 2 & year == 2010)

*2. Create Log Odds
**************************
*bysort policy_group_2008 industry date: egen firms_size_ind = total(caeqtot_capex!=.)
bysort policy_group_2008 industry date: egen firms_size_ind = total(cabltot!=.)
bysort policy_group_2008 industry date:  egen invs_size_ind = total(inv)
bysort policy_group_2008 industry date:  egen exp1_size_ind = total(exp_1)
bysort policy_group_2008 industry date:  egen exp2_size_ind = total(exp_2)

g invs_size_ind_share = invs_size_ind/firms_size_ind  // number of firms with positive investment in an industry/firms with nil or positive
g exp1_size_ind_share = exp1_size_ind/firms_size_ind  // share of firms with positive ands non-missing investment in an industry/firms with nil or positive
g exp2_size_ind_share = exp2_size_ind/firms_size_ind  // share of firms with positive investment in an industry/firms with nil or positive

g log_odds = ln(invs_size_ind_share/(1-invs_size_ind_share))
replace log_odds=4 if invs_size_ind_share==1

g log_odds_exp1 = ln(exp1_size_ind_share/(1-exp1_size_ind_share))
replace log_odds_exp1=4 if exp1_size_ind_share==1

g log_odds_exp2 = ln(exp2_size_ind_share/(1-exp2_size_ind_share))
replace log_odds_exp2=4 if exp2_size_ind_share==1

*Estimate
*****************************
*removing levels caeqtot_nz
foreach TO in policy_group_2008  {
foreach var in l_cabltot log_odds {
	
	if "`var'" ==  "l_cabltot" {
		local cluster firmid
		local control l_fte i.pct_income
	}
		if "`var'" ==  "log_odds"  {
		local cluster industry
		local control  
	}
	
eststo clear

*All entities, companies, unincorps, no mining, with controls
eststo clear
eststo: reghdfe `var'  i.`TO'##i.pol_period_2008  `control' if date>= 42 & date< 61 & division!="B" , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2008  `control' if date>= 42 & date< 61 & division!="B"  & company ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2008  `control' if date>= 42 & date< 61 & division!="B"  & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

*All entities, companies, unincorps no mining 
eststo: reghdfe `var'  i.`TO'##i.pol_period_2008 if date>= 42 & date< 61 & division!="B"  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2008 if date>= 42 & date< 61 & division!="B"  & company ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2008 if date>= 42 & date< 61 & division!="B"   & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

esttab using "2009_`var'_indicator.rtf", se keep(*policy_group_2008*) stats(N r2 ar2) star(* 0.1 ** 0.05 *** 0.01) replace mtitles("All entities" "Companies" "Unincorporated" "All entities, no controls" "Companies, no controls" "Unincorporated, no controls")
}
}


**************************************************************************************************************************************************
*2015 policy
**************************************************************************************************************************************************
gen policy_group_2015 = .
replace policy_group_2015 = 1 if (income_l < 2 000 000)
replace policy_group_2015 = 0 if (income_l > 2 000 000 & income_l < 5 000 000)

gen pol_2015_sensitivity1 = policy_group_2015
replace pol_2015_sensitivity1 = 0 if (income_l > 2 000 000 & income_l < 3 000 000)

gen pol_2015_sensitivity2 = policy_group_2015
replace pol_2015_sensitivity2 = 0 if (income_l > 2 000 000 & income_l < 7 000 000)

*policy date = 73 to 77
*estimation date = 68 to 77
g pol_period_2015 =  0
replace pol_period_2015 = ((quarter == 4 & year == 2015) | (quarter == 1 & year == 2016) | (quarter ==2 & year == 2016)  | (quarter == 3 & year == 2016)  | (quarter == 4 & year == 2016))


*Create Log Odds
**************************
drop firms_size_ind invs_size_ind exp1_size_ind exp2_size_ind invs_size_ind_share exp1_size_ind_share exp2_size_ind_share log_odds log_odds_exp1 log_odds_exp2

bysort policy_group_2015 industry date: egen firms_size_ind = total(cabltot!=.)
bysort policy_group_2015 industry date:  egen invs_size_ind = total(inv)
bysort policy_group_2015 industry date:  egen exp1_size_ind = total(exp_1)
bysort policy_group_2015 industry date:  egen exp2_size_ind = total(exp_2)

g invs_size_ind_share = invs_size_ind/firms_size_ind  // number of firms with positive investment in an industry/firms with nil or positive
g exp1_size_ind_share = exp1_size_ind/firms_size_ind  // share of firms with positive ands non-missing investment in an industry/firms with nil or positive
g exp2_size_ind_share = exp2_size_ind/firms_size_ind  // share of firms with positive investment in an industry/firms with nil or positive

g log_odds = ln(invs_size_ind_share/(1-invs_size_ind_share))
replace log_odds=4 if invs_size_ind_share==1

g log_odds_exp1 = ln(exp1_size_ind_share/(1-exp1_size_ind_share))
replace log_odds_exp1=4 if exp1_size_ind_share==1

g log_odds_exp2 = ln(exp2_size_ind_share/(1-exp2_size_ind_share))
replace log_odds_exp2=4 if exp2_size_ind_share==1

*Estimate
*****************************
*pol_2015_sensitivity1 pol_2015_sensitivity2 
foreach TO in policy_group_2015 { 

foreach var in l_cabltot log_odds {
	
	if "`var'" ==  "l_cabltot" {
		local cluster firmid
		local control l_fte i.pct_income 
	}
		if "`var'" ==  "log_odds"  {
		local cluster industry
		local control  
	}
eststo clear
eststo: reghdfe `var'  i.`TO'##i.pol_period_2015 `control' if date >=68 & date <=77 & division!="B" , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2015 `control' if date >=68 & date <=77 & division!="B" & company ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2015 `control' if date >=68 & date <=77 & division!="B" & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')



eststo: reghdfe `var'  i.`TO'##i.pol_period_2015 if date >=68 & date <=77 & division!="B"  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2015 if date >=68 & date <=77 & division!="B" & company ==1  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2015 if date >=68 & date <=77 & division!="B" & NotCompanyNorTrust ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

esttab using "2015_`var'.rtf", se keep(*policy*) stats(N r2 ar2) star(* 0.1 ** 0.05 *** 0.01) replace mtitles("All entities" "Companies" "Unincorporated" "All entities, no controls" "Companies, no controls" "Unincorporated, no controls")
}
}

**************************************************************************************************************************************************
*2016 policy
**************************************************************************************************************************************************

gen policy_group_2016 = .
replace policy_group_2016 = 1 if  (income_l > 2 000 000 & income_l < 10 000 000)
replace policy_group_2016 = 0 if (income_l > 10 000 000 & income_l < 20 000 000)

gen pol_2016_control2 = .
replace pol_2016_control2  = 1 if  (income_l > 2 000 000 & income_l < 10 000 000)
replace pol_2016_control2  = 0 if (income_l < 2 000 000)

gen pol_2016_sensitivity2 = policy_group_2016
replace pol_2016_sensitivity2 = 0 if (income_l > 10 000 000 & income_l < 25 000 000)

*policy date = 78 to 81
*estimation date = .. to 81
*next policy starts at 89 (i.e. 88 is pre policy)
g pol_period_2016 =  0
replace pol_period_2016 = ((quarter == 1 & year == 2017) | (quarter == 2 & year == 2017)| (quarter == 3 & year == 2017)| (quarter == 4 & year == 2017))


*Create Log Odds
**************************
capture drop firms_size_ind invs_size_ind exp1_size_ind exp2_size_ind invs_size_ind_share exp1_size_ind_share exp2_size_ind_share log_odds log_odds_exp1 log_odds_exp2

bysort policy_group_2016 industry date: egen firms_size_ind = total(cabltot!=.)
bysort policy_group_2016 industry date:  egen invs_size_ind = total(inv)
bysort policy_group_2016 industry date:  egen exp1_size_ind = total(exp_1)
bysort policy_group_2016 industry date:  egen exp2_size_ind = total(exp_2)

g invs_size_ind_share = invs_size_ind/firms_size_ind  // number of firms with positive investment in an industry/firms with nil or positive
g exp1_size_ind_share = exp1_size_ind/firms_size_ind  // share of firms with positive ands non-missing investment in an industry/firms with nil or positive
g exp2_size_ind_share = exp2_size_ind/firms_size_ind  // share of firms with positive investment in an industry/firms with nil or positive

g log_odds = ln(invs_size_ind_share/(1-invs_size_ind_share))
replace log_odds=4 if invs_size_ind_share==1

g log_odds_exp1 = ln(exp1_size_ind_share/(1-exp1_size_ind_share))
replace log_odds_exp1=4 if exp1_size_ind_share==1

g log_odds_exp2 = ln(exp2_size_ind_share/(1-exp2_size_ind_share))
replace log_odds_exp2=4 if exp2_size_ind_share==1

*Estimate
*****************************

foreach TO in policy_group_2016 { // pol_2016_sensitivity1 pol_2016_sensitivity2 {
*caeqtot_nz
foreach var in l_cabltot log_odds {
	
	if "`var'" ==  "l_cabltot" {
		local cluster firmid
		local control l_fte i.pct_income 
	}
		if "`var'" ==  "log_odds"  {
		local cluster industry
		local control  
	}
*margins `TO', dydx(date)

eststo clear
eststo: reghdfe `var'  i.`TO'##i.pol_period_2016  `control' if date >=70 & date <=88 & division!="B" , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2016  `control' if date >=70 & date <=88 & division!="B" & company ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2016  `control' if date >=70 & date <=88 & division!="B"  & NotCompany ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

eststo: reghdfe `var'  i.`TO'##i.pol_period_2016   if date >=70 & date <=88 & division!="B"  , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2016   if date >=70 & date <=88 & division!="B" & company ==1, a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')
eststo: reghdfe `var'  i.`TO'##i.pol_period_2016   if date >=70 & date <=88 & division!="B"  & NotCompany ==1 , a(firmid i.`TO'##i.quarter i.div##i.date) vce(cluster `cluster')

esttab using "2016_`var'.rtf", se keep(*pol*) stats(N r2 ar2) star(* 0.1 ** 0.05 *** 0.01) replace mtitles("All entities" "Companies" "Unincorporated" "All entities, no controls" "Companies, no controls" "Unincorporated, no controls")
}
}

capture log close
